To write unit tests it is suggested to use AI for 
help.

## Approach for standard unit tests

1. **Create the test file**: Decide which node you want to test and create a test file with the corresponding name in the test folder. For example, for a node in `nodeA/v2/NodeAV2.node.ts`, create a test file in `nodeA/v2/test/NodeAV2.test.ts`.

2. **Use AI assistance**: Send this prompt to your AI tool (Cursor, Copilot, Claude, etc.):
   ```
   Using guidelines in @TESTING_PROMPT.md, write tests for @NodeAV2.node.ts in @NodeAV2.node.test.ts
   ```
   Make sure file names after `@` are detected and referenced by your tool.
   You can improve the prompt by asking to cover specific test cases.

3. **Review and refine**: Thoroughly review the generated tests, make necessary fixes, and remove redundant tests. __Even if generated by AI, it's still your responsibility to ensure tests are working and reasonable.__

## Approach for workflow unit tests
Workflow unit tests are tests that use user predefined workflows in json format and NodeTestHarness helper that runs the workflow. This is closer to integration tests.

For these tests you can follow the guidelines defined above, but with some modifications:
- Use `TESTING_PROMPT_WORKFLOW.md` instead
- Use a different prompt. It's also important to specify a credentials schema if any credentials are being used, because AI struggles with identifying the schema. You can use the following prompt:
```
I need you to write workflow unit tests for @NodeAV2.node.ts in @NodeAV2.node.test.ts
using guidelines in @TESTING_PROMPT_WORKFLOW.md 
You should test each resource and operation in the node
After writing a first test make sure it passes, then write other tests.

To mock credentials use this schema
oauth2: {
    scope: '',
    oauthTokenData: {
      access_token: 'ACCESSTOKEN',
    },
  }
```