import type { MockProxy } from 'jest-mock-extended';
import { mock } from 'jest-mock-extended';
import type { ILoadOptionsFunctions } from 'n8n-workflow';

import { getMappingColumns } from '../../methods/resourceMapping';

describe('Microsoft SharePoint Node', () => {
	describe('Resource mapping', () => {
		let loadOptionsFunctions: MockProxy<ILoadOptionsFunctions>;

		beforeEach(() => {
			loadOptionsFunctions = mock<ILoadOptionsFunctions>();
		});

		afterEach(() => {
			jest.resetAllMocks();
		});

		it('should map columns', async () => {
			loadOptionsFunctions.getCredentials.mockResolvedValue({});
			loadOptionsFunctions.getNodeParameter.mockReturnValueOnce('site');
			loadOptionsFunctions.getNodeParameter.mockReturnValueOnce('list');
			loadOptionsFunctions.getNodeParameter.mockReturnValueOnce('create');
			const mockResponse = {
				value: [
					{
						'@odata.etag': '"0"',
						id: '0x0100362657F7588C5C438072A77E0EF184F4000272C0D1046D984B8097B3C00D199EDE',
						description: 'Create a new list item.',
						eTag: '"0"',
						group: 'List Content Types',
						hidden: false,
						name: 'Item',
						parentId: '0x01',
						readOnly: false,
						sealed: false,
						columns: [
							{
								displayName: 'Title',
								'@odata.etag': '"1"',
								columnGroup: 'Custom Columns',
								customFormatter: '',
								description: 'Description Title',
								enforceUniqueValues: true,
								eTag: '"1"',
								hidden: false,
								id: 'fa564e0f-0c70-4ab9-b863-0177e6ddd247',
								indexed: true,
								isDeletable: false,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'Title',
								readOnly: false,
								required: true,
								type: 'text',
								default: '',
								text: {
									allowMultipleLines: false,
									appendChangesToExistingText: false,
									autoHyperLink: true,
									linesForEditing: 0,
									maxLength: 255,
								},
								validation: {
									defaultLanguage: 'en-US',
									descriptions: [
										{
											languageTag: 'en-US',
										},
									],
								},
							},
							{
								displayName: 'Othertitle',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Descriptio Othertitle',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: '82642ec8-ef9b-478f-acf9-31f7d45fbc31',
								indexed: false,
								isDeletable: false,
								isReorderable: false,
								isSealed: false,
								propagateChanges: false,
								name: 'LinkTitle',
								readOnly: true,
								type: 'unknownFutureValue',
								default: '',
							},
							{
								displayName: 'Choice',
								'@odata.etag': '"2"',
								columnGroup: 'Custom Columns',
								customFormatter:
									'{"elmType":"div","style":{"flex-wrap":"wrap","display":"flex"},"children":[{"elmType":"div","style":{"box-sizing":"border-box","padding":"4px 8px 5px 8px","overflow":"hidden","text-overflow":"ellipsis","display":"flex","border-radius":"16px","height":"24px","align-items":"center","white-space":"nowrap","margin":"4px 4px 4px 4px"},"attributes":{"class":{"operator":":","operands":[{"operator":"==","operands":["[$choice]","Choice 1"]},"sp-css-backgroundColor-BgCornflowerBlue sp-css-color-CornflowerBlueFont",{"operator":":","operands":[{"operator":"==","operands":["[$choice]","Choice 2"]},"sp-css-backgroundColor-BgMintGreen sp-css-color-MintGreenFont",{"operator":":","operands":[{"operator":"==","operands":["[$choice]","Choice 3"]},"sp-css-backgroundColor-BgGold sp-css-color-GoldFont",{"operator":":","operands":[{"operator":"==","operands":["[$choice]",""]},"","sp-field-borderAllRegular sp-field-borderAllSolid sp-css-borderColor-neutralSecondary"]}]}]}]}},"children":[{"elmType":"span","style":{"overflow":"hidden","text-overflow":"ellipsis","padding":"0 3px"},"txtContent":"[$choice]","attributes":{"class":{"operator":":","operands":[{"operator":"==","operands":["[$choice]","Choice 1"]},"sp-css-color-CornflowerBlueFont",{"operator":":","operands":[{"operator":"==","operands":["[$choice]","Choice 2"]},"sp-css-color-MintGreenFont",{"operator":":","operands":[{"operator":"==","operands":["[$choice]","Choice 3"]},"sp-css-color-GoldFont",{"operator":":","operands":[{"operator":"==","operands":["[$choice]",""]},"",""]}]}]}]}}}]}],"templateId":"BgColorChoicePill"}',
								description: 'Description Choice',
								enforceUniqueValues: false,
								eTag: '"2"',
								hidden: false,
								id: '21d4577a-e5f2-461d-a9cf-f7956c502f4e',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'choice',
								readOnly: false,
								type: 'choice',
								default: '',
								choice: {
									allowTextEntry: false,
									choices: ['Choice 1', 'Choice 2', 'Choice 3'],
									displayAs: 'dropDownMenu',
								},
								validation: {
									defaultLanguage: 'en-US',
									descriptions: [
										{
											languageTag: 'en-US',
										},
									],
								},
							},
							{
								displayName: 'Datetime',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Description Datetime',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: '7e2cf00a-1df6-4c1c-8ea9-d92ef3c7760e',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'datetime',
								readOnly: false,
								type: 'dateTime',
								default: '',
								dateTime: {
									displayAs: 'standard',
									format: 'dateOnly',
								},
								validation: {
									defaultLanguage: 'en-US',
									descriptions: [
										{
											languageTag: 'en-US',
										},
									],
								},
							},
							{
								displayName: 'Person',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Description Person',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: '574f4483-ec83-41a0-b772-67b331695c56',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'person',
								readOnly: false,
								type: 'user',
								default: '',
								personOrGroup: {
									allowMultipleSelection: false,
									displayAs: 'nameWithPresence',
									format: 'peopleOnly',
									hasPrefix: false,
									noLookupFieldHeader: false,
								},
							},
							{
								displayName: 'Number',
								'@odata.etag': '"2"',
								columnGroup: 'Custom Columns',
								description: 'Description Number',
								enforceUniqueValues: false,
								eTag: '"2"',
								hidden: false,
								id: 'c69c2fc9-b6fd-4a08-8750-a293b7c888a3',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'number',
								readOnly: false,
								type: 'number',
								default: 0,
								number: {
									decimalPlaces: 'automatic',
									displayAs: 'number',
									maximum: 1.7976931348623157e308,
									minimum: -1.7976931348623157e308,
								},
								validation: {
									defaultLanguage: 'en-US',
									descriptions: [
										{
											languageTag: 'en-US',
										},
									],
								},
							},
							{
								displayName: 'Bool',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Whether Description Bool',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: '955880c3-8c95-4609-93ef-cdbd2deef1b2',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'bool',
								readOnly: false,
								type: 'boolean',
								default: false,
								boolean: {},
								defaultValue: {
									value: '1',
								},
							},
							{
								displayName: 'Hyperlink',
								'@odata.etag': '"2"',
								columnGroup: 'Custom Columns',
								description: 'Description Hyperlink',
								enforceUniqueValues: false,
								eTag: '"2"',
								hidden: false,
								id: 'a6352b41-95e7-4cbf-9184-aae4fe92d865',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'hyperlink',
								readOnly: false,
								type: 'url',
								default: '',
								hyperlinkOrPicture: {
									isPicture: false,
								},
							},
							{
								displayName: 'Currency',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Description Currency',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: '40d9b8f9-05e0-4105-bc35-0c969eeb0096',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'currency',
								readOnly: false,
								type: 'currency',
								default: '',
								currency: {
									decimalPlaces: 'automatic',
									displayAs: 'number',
									locale: 'en-US',
									maximum: 1.7976931348623157e308,
									minimum: -1.7976931348623157e308,
								},
								validation: {
									defaultLanguage: 'en-US',
									descriptions: [
										{
											languageTag: 'en-US',
										},
									],
								},
							},
							{
								displayName: 'Location',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Description Location',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: '5bfb0a2c-04ed-4a59-ae6e-de0d97c8352b',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'location',
								readOnly: false,
								type: 'location',
								default: '',
								location: {},
							},
							{
								displayName: 'location: Country/Region',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Description Location: Country/Region',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: 'db61a63e-558b-4e41-b895-2da2f40a7a23',
								indexed: false,
								isDeletable: true,
								isReorderable: false,
								isSealed: true,
								propagateChanges: false,
								name: 'CountryOrRegion',
								readOnly: true,
								type: 'text',
								default: '',
								text: {
									allowMultipleLines: false,
									appendChangesToExistingText: false,
									autoHyperLink: false,
									linesForEditing: 0,
									maxLength: 255,
								},
								validation: {
									defaultLanguage: 'en-US',
									descriptions: [
										{
											languageTag: 'en-US',
										},
									],
								},
							},
							{
								displayName: 'location: State',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Description Location: State',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: 'c24ae779-ee80-4e8c-b291-c716f1fdce66',
								indexed: false,
								isDeletable: true,
								isReorderable: false,
								isSealed: true,
								propagateChanges: false,
								name: 'State',
								readOnly: true,
								type: 'text',
								default: '',
								text: {
									allowMultipleLines: false,
									appendChangesToExistingText: false,
									autoHyperLink: false,
									linesForEditing: 0,
									maxLength: 255,
								},
								validation: {
									defaultLanguage: 'en-US',
									descriptions: [
										{
											languageTag: 'en-US',
										},
									],
								},
							},
							{
								displayName: 'location: City',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Description Location: City',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: '7fb3c8e7-8a8c-4488-a768-4db6922b53f4',
								indexed: false,
								isDeletable: true,
								isReorderable: false,
								isSealed: true,
								propagateChanges: false,
								name: 'City',
								readOnly: true,
								type: 'text',
								default: '',
								text: {
									allowMultipleLines: false,
									appendChangesToExistingText: false,
									autoHyperLink: false,
									linesForEditing: 0,
									maxLength: 255,
								},
								validation: {
									defaultLanguage: 'en-US',
									descriptions: [
										{
											languageTag: 'en-US',
										},
									],
								},
							},
							{
								displayName: 'location: Postal Code',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Description Location: Postal Code',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: '1fa93efa-579f-48cb-b1e3-f2a8fdb615fe',
								indexed: false,
								isDeletable: true,
								isReorderable: false,
								isSealed: true,
								propagateChanges: false,
								name: 'PostalCode',
								readOnly: true,
								type: 'text',
								default: '',
								text: {
									allowMultipleLines: false,
									appendChangesToExistingText: false,
									autoHyperLink: false,
									linesForEditing: 0,
									maxLength: 255,
								},
								validation: {
									defaultLanguage: 'en-US',
									descriptions: [
										{
											languageTag: 'en-US',
										},
									],
								},
							},
							{
								displayName: 'location: Street',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Description Location: Street',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: '1ce8048e-a619-40fb-86b2-c5963c0a7526',
								indexed: false,
								isDeletable: true,
								isReorderable: false,
								isSealed: true,
								propagateChanges: false,
								name: 'Street',
								readOnly: true,
								type: 'text',
								default: '',
								text: {
									allowMultipleLines: false,
									appendChangesToExistingText: false,
									autoHyperLink: false,
									linesForEditing: 0,
									maxLength: 255,
								},
								validation: {
									defaultLanguage: 'en-US',
									descriptions: [
										{
											languageTag: 'en-US',
										},
									],
								},
							},
							{
								displayName: 'location: Coordinates',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Description Location: Coordinates',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: '079b0670-2a3d-4a71-abe5-c0023a66879d',
								indexed: false,
								isDeletable: true,
								isReorderable: false,
								isSealed: true,
								propagateChanges: false,
								name: 'GeoLoc',
								readOnly: true,
								type: 'geolocation',
								default: '',
								geolocation: {},
							},
							{
								displayName: 'location: Name',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Description Location: Name',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: '73a8bcce-484b-4fd6-84be-47ef648c9c45',
								indexed: false,
								isDeletable: true,
								isReorderable: false,
								isSealed: true,
								propagateChanges: false,
								name: 'DispName',
								readOnly: true,
								type: 'text',
								default: '',
								text: {
									allowMultipleLines: false,
									appendChangesToExistingText: false,
									autoHyperLink: false,
									linesForEditing: 0,
									maxLength: 255,
								},
								validation: {
									defaultLanguage: 'en-US',
									descriptions: [
										{
											languageTag: 'en-US',
										},
									],
								},
							},
							{
								displayName: 'Image',
								'@odata.etag': '"0"',
								columnGroup: 'Custom Columns',
								description: 'Description Location: Image',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: '2a485bec-bab9-493b-9214-2be0b8566a25',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'image',
								readOnly: false,
								type: 'thumbnail',
								default: '',
								thumbnail: {},
							},
							{
								displayName: 'Metadata',
								'@odata.etag': '"2"',
								columnGroup: 'Custom Columns',
								customFormatter: '',
								description: 'Description Location: Metadata',
								enforceUniqueValues: false,
								eTag: '"2"',
								hidden: false,
								id: '2d8cb8ec-4a8f-43ae-87fa-e832b4631f0d',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'metadata',
								readOnly: false,
								staticName: 'metadata',
								type: 'term',
								default: '',
								defaultValue: {
									value: '',
								},
								term: {
									allowMultipleValues: false,
									showFullyQualifiedName: false,
								},
							},
							{
								displayName: 'Lookup',
								'@odata.etag': '"2"',
								columnGroup: 'Custom Columns',
								description: 'Description Lookup',
								enforceUniqueValues: false,
								eTag: '"2"',
								hidden: false,
								id: '44bdab3a-ac89-4b40-acfd-707510f93719',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'lookup',
								readOnly: false,
								type: 'lookup',
								default: '',
								lookup: {
									allowMultipleValues: false,
									allowUnlimitedLength: false,
									columnName: 'Title',
									displayFormUrl:
										'https://mydomain.sharepoint.com/sites/n8ntest10/_layouts/15/listform.aspx?PageType=4&ListId=58a279af-1f06-4392-a5ed-2b37fa1d6c1d',
									listId: '58a279af-1f06-4392-a5ed-2b37fa1d6c1d',
								},
							},
							{
								displayName: 'Rating (0-5)',
								'@odata.etag': '"1"',
								columnGroup: 'Content Feedback',
								description: 'Average value of all the ratings that have been submitted',
								enforceUniqueValues: false,
								eTag: '"1"',
								hidden: false,
								id: '5a14d1ab-1513-48c7-97b3-657a5ba6c742',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'AverageRating',
								readOnly: false,
								type: 'unknownFutureValue',
								default: '',
							},
							{
								displayName: 'Number of Ratings',
								'@odata.etag': '"0"',
								columnGroup: 'Content Feedback',
								description: 'Number of ratings submitted',
								enforceUniqueValues: false,
								eTag: '"0"',
								hidden: false,
								id: 'b1996002-9167-45e5-a4df-b2c41c6723c7',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'RatingCount',
								readOnly: false,
								type: 'unknownFutureValue',
								default: '',
							},
							{
								displayName: 'Number of Likes',
								'@odata.etag': '"1"',
								columnGroup: 'Content Feedback',
								description: 'Description Number of Likes',
								enforceUniqueValues: false,
								eTag: '"1"',
								hidden: false,
								id: '6e4d832b-f610-41a8-b3e0-239608efda41',
								indexed: false,
								isDeletable: true,
								isReorderable: true,
								isSealed: false,
								propagateChanges: false,
								name: 'LikesCount',
								readOnly: false,
								type: 'unknownFutureValue',
								default: '',
							},
						],
					},
				],
			};
			loadOptionsFunctions.helpers.httpRequestWithAuthentication = jest
				.fn()
				.mockReturnValue(mockResponse);

			const fields = await getMappingColumns.call(loadOptionsFunctions);

			expect(fields).toEqual({
				fields: [
					{
						id: 'Title',
						canBeUsedToMatch: true,
						defaultMatch: false,
						display: true,
						displayName: 'Title',
						readOnly: false,
						required: true,
						type: 'string',
					},
					{
						id: 'choice',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Choice',
						readOnly: false,
						required: undefined,
						type: 'options',
						options: [
							{
								name: 'Choice 1',
								value: 'Choice 1',
							},
							{
								name: 'Choice 2',
								value: 'Choice 2',
							},
							{
								name: 'Choice 3',
								value: 'Choice 3',
							},
						],
					},
					{
						id: 'datetime',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Datetime',
						readOnly: false,
						required: undefined,
						type: 'dateTime',
					},
					{
						id: 'person',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Person',
						readOnly: false,
						required: undefined,
						type: 'string',
					},
					{
						id: 'number',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Number',
						readOnly: false,
						required: undefined,
						type: 'number',
					},
					{
						id: 'bool',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Bool',
						readOnly: false,
						required: undefined,
						type: 'boolean',
					},
					{
						id: 'hyperlink',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Hyperlink',
						readOnly: true,
						required: undefined,
						type: undefined,
					},
					{
						id: 'currency',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Currency',
						readOnly: false,
						required: undefined,
						type: 'number',
					},
					{
						id: 'location',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Location',
						readOnly: true,
						required: undefined,
						type: undefined,
					},
					{
						id: 'image',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Image',
						readOnly: false,
						required: undefined,
						type: 'object',
					},
					{
						id: 'metadata',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Metadata',
						readOnly: true,
						required: undefined,
						type: undefined,
					},
					{
						id: 'lookup',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Lookup',
						readOnly: false,
						required: undefined,
						type: 'string',
					},
					{
						id: 'AverageRating',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Rating (0-5)',
						readOnly: false,
						required: undefined,
						type: 'number',
					},
					{
						id: 'RatingCount',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Number of Ratings',
						readOnly: false,
						required: undefined,
						type: 'number',
					},
					{
						id: 'LikesCount',
						canBeUsedToMatch: false,
						defaultMatch: false,
						display: true,
						displayName: 'Number of Likes',
						readOnly: false,
						required: undefined,
						type: 'number',
					},
				],
			});
		});

		it('should map columns with id for update', async () => {
			loadOptionsFunctions.getCredentials.mockResolvedValue({});
			loadOptionsFunctions.getNodeParameter.mockReturnValueOnce('site');
			loadOptionsFunctions.getNodeParameter.mockReturnValueOnce('list');
			loadOptionsFunctions.getNodeParameter.mockReturnValueOnce('update');
			const mockResponse = {
				value: [
					{
						columns: [],
					},
				],
			};
			loadOptionsFunctions.helpers.httpRequestWithAuthentication = jest
				.fn()
				.mockReturnValue(mockResponse);

			const fields = await getMappingColumns.call(loadOptionsFunctions);

			expect(fields).toEqual({
				fields: [
					{
						id: 'id',
						canBeUsedToMatch: true,
						defaultMatch: false,
						display: true,
						displayName: 'ID',
						readOnly: true,
						required: true,
						type: 'string',
					},
				],
			});
		});
	});
});
